/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.SyncPersistentDataPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class PersistentDataCapability {
    private static final ResourceLocation ID = TConstruct.getResource("persistent_data");
    public static final Capability<NamespacedNBT> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<NamespacedNBT>(){});

    private PersistentDataCapability() {
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, PersistentDataCapability::register);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, PersistentDataCapability::attachCapability);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.Clone.class, PersistentDataCapability::playerClone);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerRespawnEvent.class, PersistentDataCapability::playerRespawn);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerChangedDimensionEvent.class, PersistentDataCapability::playerChangeDimension);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedInEvent.class, PersistentDataCapability::playerLoggedIn);
    }

    private static void register(RegisterCapabilitiesEvent event) {
        event.register(NamespacedNBT.class);
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            Provider provider = new Provider();
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener((Runnable)provider);
        }
    }

    private static void sync(Player player) {
        player.getCapability(CAPABILITY).ifPresent(data -> TinkerNetwork.getInstance().sendTo(new SyncPersistentDataPacket(data.getCopy()), player));
    }

    private static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().getCapability(CAPABILITY).ifPresent(oldData -> {
            CompoundTag nbt = oldData.getCopy();
            if (!nbt.m_128456_()) {
                event.getPlayer().getCapability(CAPABILITY).ifPresent(newData -> newData.copyFrom(nbt));
            }
        });
    }

    private static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PersistentDataCapability.sync(event.getPlayer());
    }

    private static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PersistentDataCapability.sync(event.getPlayer());
    }

    private static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PersistentDataCapability.sync(event.getPlayer());
    }

    private static class Provider
    implements ICapabilitySerializable<CompoundTag>,
    Runnable {
        private Lazy<CompoundTag> nbt = Lazy.of(CompoundTag::new);
        private LazyOptional<NamespacedNBT> capability = LazyOptional.of(() -> NamespacedNBT.readFromNBT((CompoundTag)this.nbt.get()));

        private Provider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.capability);
        }

        @Override
        public void run() {
            this.capability.invalidate();
            this.capability = LazyOptional.of(() -> NamespacedNBT.readFromNBT((CompoundTag)this.nbt.get()));
        }

        public CompoundTag serializeNBT() {
            return ((CompoundTag)this.nbt.get()).m_6426_();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.nbt = Lazy.of(() -> nbt);
            this.run();
        }
    }
}

